/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.internal.core.parsing.sdoc.model;

import com.aptana.core.util.SourcePrinter;
import com.aptana.js.internal.core.parsing.sdoc.model.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionType
extends Type {
    private List<Type> _parameterTypes;
    private List<Type> _returnTypes;

    public FunctionType() {
        super("Function");
    }

    public void addParameterType(Type parameterType) {
        if (parameterType != null) {
            if (this._parameterTypes == null) {
                this._parameterTypes = new ArrayList<Type>();
            }
            this._parameterTypes.add(parameterType);
        }
    }

    public void addReturnType(Type returnType) {
        if (returnType != null) {
            if (this._returnTypes == null) {
                this._returnTypes = new ArrayList<Type>();
            }
            this._returnTypes.add(returnType);
        }
    }

    public List<Type> getReturnTypes() {
        List<Type> result = this._returnTypes;
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public void toSource(SourcePrinter writer) {
        boolean first;
        writer.print("Function");
        if (this._parameterTypes != null && !this._parameterTypes.isEmpty()) {
            first = true;
            writer.print('(');
            for (Type type : this._parameterTypes) {
                if (!first) {
                    writer.print(',');
                } else {
                    first = false;
                }
                type.toSource(writer);
            }
            writer.print(')');
        }
        if (this._returnTypes != null && !this._returnTypes.isEmpty()) {
            first = true;
            writer.print("->");
            if (this._returnTypes.size() > 1) {
                writer.print('(');
            }
            for (Type type : this._returnTypes) {
                if (!first) {
                    writer.print(',');
                } else {
                    first = false;
                }
                type.toSource(writer);
            }
            if (this._returnTypes.size() > 1) {
                writer.print(')');
            }
        }
    }
}

